#include <stdio.h>

#define MAX_STUDENTS 10

struct Student {
    int id;
    char name[50];
    int age;
    char address[100];
};

int main() {
    struct Student students[MAX_STUDENTS];
    int numStudents;

    printf("Enter the number of students (up to %d): ", MAX_STUDENTS);
    scanf("%d", &numStudents);
    printf("Enter student details:\n");
    for (int i = 0; i < numStudents; i++) {
        printf("Student %d:\n", i + 1);
        printf("ID: ");
        scanf("%d", &students[i].id);

        printf("Name: ");
        scanf("%s", students[i].name);

        printf("Age (between 18 and 24): ");
        scanf("%d", &students[i].age);
        while (students[i].age < 18 || students[i].age > 24) {
            printf("Invalid age! Age must be between 18 and 24. Please enter again: ");
            scanf("%d", &students[i].age);
        }

        printf("Address: ");
        scanf("%s", students[i].address);
    }

    int searchId;
    printf("\nEnter the ID of the student you want to search for: ");
    scanf("%d", &searchId);

    int found = 0;
    for (int i = 0; i < numStudents; i++) {
        if (students[i].id == searchId) {
            found = 1;
            printf("\nStudent found:\n");
            printf("ID: %d\n", students[i].id);
            printf("Name: %s\n", students[i].name);
            printf("Age: %d\n", students[i].age);
            printf("Address: %s\n", students[i].address);
            break;
        }
    }

    if (!found) {
        printf("\nStudent with ID %d not found.\n", searchId);
    }

    return 0;
}
